@if ($paginator->hasPages())
    <nav role="navigation" aria-label="{{ __('Pagination Navigation') }}" class="sam-pagination">
        <div class="sam-pagination-info">
            <p class="sam-pagination-text">
                Showing {{ $paginator->firstItem() }} to {{ $paginator->lastItem() }} of {{ $paginator->total() }} results
            </p>
        </div>

        <div class="sam-pagination-links">
            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <span class="pagination-button disabled">
                    <i class="fas fa-chevron-left"></i>
                    Previous
                </span>
            @else
                <a href="{{ $paginator->previousPageUrl() }}" class="pagination-button">
                    <i class="fas fa-chevron-left"></i>
                    Previous
                </a>
            @endif

            {{-- Pagination Elements --}}
            @foreach ($elements as $element)
                {{-- "Three Dots" Separator --}}
                @if (is_string($element))
                    <span class="pagination-ellipsis">{{ $element }}</span>
                @endif

                {{-- Array Of Links --}}
                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        @if ($page == $paginator->currentPage())
                            <span class="pagination-button active">{{ $page }}</span>
                        @else
                            <a href="{{ $url }}" class="pagination-button">{{ $page }}</a>
                        @endif
                    @endforeach
                @endif
            @endforeach

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <a href="{{ $paginator->nextPageUrl() }}" class="pagination-button">
                    Next
                    <i class="fas fa-chevron-right"></i>
                </a>
            @else
                <span class="pagination-button disabled">
                    Next
                    <i class="fas fa-chevron-right"></i>
                </span>
            @endif
        </div>
    </nav>

    <style>
    .sam-pagination {
        display: flex;
        justify-content: space-between;
        align-items: center;
        gap: var(--spacing-md);
        flex-wrap: wrap;
    }

    .sam-pagination-info {
        color: var(--light-gray);
        font-size: 0.9rem;
    }

    .sam-pagination-links {
        display: flex;
        align-items: center;
        gap: var(--spacing-sm);
    }

    .sam-pagination-text {
        margin: 0;
    }

    @media (max-width: var(--breakpoint-sm)) {
        .sam-pagination {
            flex-direction: column;
            text-align: center;
        }
        
        .sam-pagination-links {
            justify-content: center;
            flex-wrap: wrap;
        }
    }
    </style>
@endif